// This file is part of the AMD Anti-Lag 2 Unreal Engine Plugin.
//
// Copyright (c) 2024-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

using System;
using System.IO;
using UnrealBuildTool;
using System.Globalization;

public class AntiLag2 : ModuleRules
{
	public AntiLag2(ReadOnlyTargetRules Target) : base(Target)
	{
		PrivateDependencyModuleNames.AddRange(new string[] {
			"Core",
			"ApplicationCore",
			"Engine",
			"RHI",
			"RHICore",
			"RenderCore",
			"SlateCore",
			"Slate",
			"AntiLag2Settings"
		});
		
		if (Target.IsInPlatformGroup(UnrealPlatformGroup.Windows))
		{
			PublicDefinitions.Add("PLATFORM_SUPPORTS_ANTILAG2=1");

			PrivateIncludePaths.AddRange(
				new string[] {
					// ... add other private include paths required here ...
					Path.Combine(ModuleDirectory, "../antilag2-sdk"),
				});

			AddEngineThirdPartyPrivateStaticDependencies(Target, "DX12");
		}
		else
		{
			PublicDefinitions.Add("PLATFORM_SUPPORTS_ANTILAG2=0");
		}
	}
}