// This file is part of the AMD Anti-Lag 2 Unreal Engine Plugin.
//
// Copyright (c) 2024-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#pragma once

#include "IAntiLag2.h"
#include "Performance/MaxTickRateHandlerModule.h"

struct FAntiLag2Backend
{
	void* (*Initialize)(void);
	uint64 (*DeInitialize)(void* context);
	uint32 (*Update)(void* context, bool enable, unsigned int maxFPS);
	uint32 (*SetFrameGenFrameType)(void* context, bool bInterpolatedFrame);
	uint32 (*MarkEndOfFrameRendering)(void* context);
};

DECLARE_LOG_CATEGORY_EXTERN(LogAntiLag2, Log, All);
class ANTILAG2_API FAntiLag2Module : public IAntiLag2Module, public IMaxTickRateHandlerModule
{
public:
	FAntiLag2Module();
	virtual ~FAntiLag2Module();

    virtual void StartupModule() override;
	virtual void ShutdownModule() override;

	virtual void MarkEndOfFrameRendering();
	virtual void SetFrameType(bool const bInterpolatedFrame);

	virtual void Initialize() final;
	virtual void SetEnabled(bool bInEnabled) final;
	virtual bool GetEnabled() final;
	virtual bool GetAvailable() final;

	virtual void SetFlags(uint32 Flags) final;
	virtual uint32 GetFlags() final;

	// Return true if waiting occurred in the plugin, if false engine will use the default sleep setup
	virtual bool HandleMaxTickRate(float DesiredMaxTickRate) final;

private:
	static void OnChangeAntiLag2Enabled(IConsoleVariable* Var);

	bool Update();

private:
	static int32 RenderThreadTimeout;
	FAntiLag2Backend Backend;
	FCriticalSection Mutex;
	FDelegateHandle BackBufferReadyToPresentDelegate;
	void* Context;
	float CachedDesiredMaxTickRate;
	bool bExternalCaller;
};