# HIPRT Tutorials

## List of tutorials

| Demo name  | Image  | Documentation | Description |
|---|:---:|:--:|--|
|[01_geom_intersection](./01_geom_intersection)   | <img src="./imgs/01_geom_intersection.png" alt="drawing" width="100"/>  | [:page_facing_up:](../doc/01_geom_intersection.md) | Intersection using hiprtGeometry. |
|[02_scene_intersection](./02_scene_intersection)   | <img src="./imgs/02_scene_intersection.png" alt="drawing" width="100"/>  | [:page_facing_up:](../doc/02_scene_intersection.md) | Intersection using hiprtScene. |
|[03_custom_intersection](./03_custom_intersection)   | <img src="./imgs/03_custom_intersection.png" alt="drawing" width="100"/>  | [:page_facing_up:](../doc/03_custom_intersection.md) | Using a custom intersection function. |
|[04_compaction](./04_compaction)   | <img src="./imgs/04_compaction.png" alt="drawing" width="100"/>  | | Acceleration structure compaction. |
|[05_global_stack](./05_global_stack)   | <img src="./imgs/05_global_stack.png" alt="drawing" width="100"/>  | | Global traversal stack for good performance. | 
|[06_dynamic_stack](./06_dynamic_stack)   | <img src="./imgs/06_dynamic_stack.png" alt="drawing" width="100"/>  | | Dynamic traversal stack for balancing performance and memory requirements. | 
|[07_custom_bvh](./07_custom_bvh_import)   | <img src="./imgs/07_custom_bvh_import.png" alt="drawing" width="100"/>  | [:page_facing_up:](../doc/07_custom_bvh_import.md) | Loading a BVH a user provides. |
|[08_ambient_occlusion](./08_ambient_occlusion)   | <img src="./imgs/08_ambient_occlusion.png" alt="drawing" width="100"/>  | [:page_facing_up:](../doc/08_ambient_occlusion.md) | Ambient occlusion. |
|[09_motion_blur_srt](./09_motion_blur)   | <img src="./imgs/09_motion_blur_srt.png" alt="drawing" width="100"/>  | | Rendering objects under motion using SRT components. |
|[10_motion_blur_matrix](./10_motion_blur)   | <img src="./imgs/10_motion_blur_matrix.png" alt="drawing" width="100"/>  | | Rendering objects under motion using Matrix. |
|[11_multi_custom_intersection](./11_multi_custom_intersection)   | <img src="./imgs/11_multi_custom_intersection.png" alt="drawing" width="100"/>  | [:page_facing_up:](../doc/11_multi_custom_intersection.md) | Multiple primitives with custom intersection. |
|[12_cutout](./12_cutout)   | <img src="./imgs/12_cutout.png" alt="drawing" width="100"/>  | | Alpha masking using the intersection filter. |
|[13_concurrent_scene_build](./13_concurrent_scene_build)   | <img src="./imgs/13_concurrent_scene_build.png" alt="drawing" width="100"/>  | | Build geometries using multiple streams concurrently. |
|[14_batch_build](./14_batch_build)   | <img src="./imgs/14_batch_build.png" alt="drawing" width="100"/>  | | Build small geometries concurrently in a single batch. |
|[15_multi_level_instancing](./15_multi_level_instancing)   | <img src="./imgs/15_multi_level_instancing.png" alt="drawing" width="100"/>  | | Multi-level instancing. |
|[16_fluid_simulation](./16_fluid_simulation)   | <img src="./imgs/16_fluid_simulation.png" alt="drawing" width="100"/>  | | A simple fluid simulation. |
|[18_shadow_ray](./18_shadow_ray)   | <img src="./imgs/18_shadow_ray.png" alt="drawing" width="100"/>  | [:page_facing_up:](../doc/18_shadow_ray.md) | Shows how to trace a shadow ray in an OBJ scene. |
|[19_primary_ray](./19_primary_ray)   | <img src="./imgs/19_primary_ray.png" alt="drawing" width="100"/>  | [:page_facing_up:](../doc/19_primary_ray.md) | Shows how to trace different types of primary rays in an OBJ scene. |
