#line 1 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"


#line 32


#line 1 "common.h"


#line 20







#line 34 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"


#line 39


#line 1 "GLTFPbrPass-IO.hlsl"


#line 25
struct VS_INPUT_SCENE 
{ 
    float3 Position : POSITION ; 
    
    float3 Normal : NORMAL ; 
    
    
    float4 Tangent : TANGENT ; 
    
    
    float2 UV0 : TEXCOORD0 ; 
    
    
#line 39
    
    
#line 43
    
    
#line 49
    
    
#line 52
    
    
#line 58
    
    
#line 61
    
} ; 

#line 68
struct VS_OUTPUT_SCENE 
{ 
    float4 svPosition : SV_POSITION ; 
    float3 WorldPos : WORLDPOS ; 
    
    float3 Normal : NORMAL ; 
    
    
    float3 Tangent : TANGENT ; 
    float3 Binormal : BINORMAL ; 
    
    
#line 81
    
    
    float2 UV0 : TEXCOORD0 ; 
    
    
#line 87
    
    
#line 92
    
} ; 



#line 61 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"




#line 66


#line 69


#line 72


#line 75


#line 78



#line 91


#line 1 "perFrameStruct.h"


#line 23
struct Light 
{ 
    matrix mLightViewProj ; 
    
    float3 direction ; 
    float range ; 
    
    float3 color ; 
    float intensity ; 
    
    float3 position ; 
    float innerConeCos ; 
    
    float outerConeCos ; 
    int type ; 
    float depthBias ; 
    int shadowMapIndex ; 
} ; 

static const int LightType_Directional = 0 ; 
static const int LightType_Point = 1 ; 
static const int LightType_Spot = 2 ; 

struct PerFrame 
{ 
    matrix u_mCameraViewProj ; 
    matrix u_mCameraViewProjInverse ; 
    float4 u_CameraPos ; 
    float u_iblFactor ; 
    float u_EmissiveFactor ; 
    
    int u_padding ; 
    
    int u_lightCount ; 
    Light u_lights [ 4 ] ; 
} ; 


#line 93 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"
cbuffer cbPerFrame : register ( b0 ) 
{ 
    PerFrame myPerFrame ; 
} ; 

#line 102
cbuffer cbPerObject : register ( b1 ) 
{ 
    matrix myPerObject_u_mWorld ; 
    float4 myPerObject_u_EmissiveFactor ; 
    
#line 108
    float4 myPerObject_u_BaseColorFactor ; 
    float myPerObject_u_MetallicFactor ; 
    float myPerObject_u_RoughnessFactor ; 
    
    float2 myPerObject_u_padding ; 
    
#line 115
    float4 myPerObject_u_DiffuseFactor ; 
    float3 myPerObject_u_SpecularFactor ; 
    float myPerObject_u_GlossinessFactor ; 
    
} ; 



#line 1 "textures.hlsl"


#line 23



Texture2D baseColorTexture : register ( T1 ) ; 
SamplerState samBaseColor : register ( s1 ) ; 



Texture2D normalTexture : register ( T3 ) ; 
SamplerState samNormal : register ( s3 ) ; 


#line 38



Texture2D metallicRoughnessTexture : register ( T2 ) ; 
SamplerState samMetallicRoughness : register ( s2 ) ; 


#line 49


#line 54


#line 60



Texture2D brdfTexture : register ( T0 ) ; 
SamplerState samBRDF : register ( s0 ) ; 


#line 72


#line 77


#line 80
float2 getNormalUV ( VS_OUTPUT_SCENE Input ) 
{ 
    float3 uv = float3 ( 0.0 , 0.0 , 1.0 ) ; 
    
    uv . xy = Input . UV0 ; 
    
#line 87
    
    
    return uv . xy ; 
} 

float2 getEmissiveUV ( VS_OUTPUT_SCENE Input ) 
{ 
    float3 uv = float3 ( 0.0 , 0.0 , 1.0 ) ; 
    
    uv . xy = Input . UV0 ; 
    
#line 99
    
    
    
    return uv . xy ; 
} 

float2 getOcclusionUV ( VS_OUTPUT_SCENE Input ) 
{ 
    float3 uv = float3 ( 0.0 , 0.0 , 1.0 ) ; 
    
    uv . xy = Input . UV0 ; 
    
#line 112
    
    
    return uv . xy ; 
} 

float2 getBaseColorUV ( VS_OUTPUT_SCENE Input ) 
{ 
    float3 uv = float3 ( 0.0 , 0.0 , 1.0 ) ; 
    
    uv . xy = Input . UV0 ; 
    
#line 124
    
    
    return uv . xy ; 
} 

float2 getMetallicRoughnessUV ( VS_OUTPUT_SCENE Input ) 
{ 
    float3 uv = float3 ( 0.0 , 0.0 , 1.0 ) ; 
    
    uv . xy = Input . UV0 ; 
    
#line 136
    
    
    return uv . xy ; 
} 

float2 getSpecularGlossinessUV ( VS_OUTPUT_SCENE Input ) 
{ 
    float3 uv = float3 ( 0.0 , 0.0 , 1.0 ) ; 
    
#line 149
    
    return uv . xy ; 
} 

float2 getDiffuseUV ( VS_OUTPUT_SCENE Input ) 
{ 
    float3 uv = float3 ( 0.0 , 0.0 , 1.0 ) ; 
    
#line 161
    
    return uv . xy ; 
} 

float4 getBaseColorTexture ( VS_OUTPUT_SCENE Input ) 
{ 
    
    return baseColorTexture . Sample ( samBaseColor , getBaseColorUV ( Input ) ) ; 
    
#line 171
    
} 

float3 getNormalTexture ( VS_OUTPUT_SCENE Input ) 
{ 
    
    return normalTexture . Sample ( samNormal , getNormalUV ( Input ) ) . rgb ; 
    
#line 180
    
} 

void discardPixelIfAlphaCutOff ( VS_OUTPUT_SCENE Input ) 
{ 
    
    float4 baseColor = getBaseColorTexture ( Input ) ; 
    
#line 194
    
    
    
    
} 

#line 122 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"


#line 1 "functions.hlsl"


#line 17
static const float M_PI = 3.141592653589793 ; 
static const float c_MinReflectance = 0.04 ; 

struct AngularInfo 
{ 
    float NdotL ; 
    float NdotV ; 
    float NdotH ; 
    float LdotH ; 
    
    float VdotH ; 
    
    float3 padding ; 
} ; 

float getPerceivedBrightness ( float3 vec ) 
{ 
    return sqrt ( 0.299 * vec . r * vec . r + 0.587 * vec . g * vec . g + 0.114 * vec . b * vec . b ) ; 
} 

#line 38
float solveMetallic ( float3 diffuse , float3 specular , float oneMinusSpecularStrength ) { 
    float specularBrightness = getPerceivedBrightness ( specular ) ; 
    
    if ( specularBrightness < c_MinReflectance ) { 
        return 0.0 ; 
    } 
    
    float diffuseBrightness = getPerceivedBrightness ( diffuse ) ; 
    
    float a = c_MinReflectance ; 
    float b = diffuseBrightness * oneMinusSpecularStrength / ( 1.0 - c_MinReflectance ) + specularBrightness - 2.0 * c_MinReflectance ; 
    float c = c_MinReflectance - specularBrightness ; 
    float D = b * b - 4.0 * a * c ; 
    
    return clamp ( ( - b + sqrt ( D ) ) / ( 2.0 * a ) , 0.0 , 1.0 ) ; 
} 

AngularInfo getAngularInfo ( float3 pointToLight , float3 normal , float3 view ) 
{ 
    
    float3 n = normalize ( normal ) ; 
    float3 v = normalize ( view ) ; 
    float3 l = normalize ( pointToLight ) ; 
    float3 h = normalize ( l + v ) ; 
    
    float NdotL = clamp ( dot ( n , l ) , 0.0 , 1.0 ) ; 
    float NdotV = clamp ( dot ( n , v ) , 0.0 , 1.0 ) ; 
    float NdotH = clamp ( dot ( n , h ) , 0.0 , 1.0 ) ; 
    float LdotH = clamp ( dot ( l , h ) , 0.0 , 1.0 ) ; 
    float VdotH = clamp ( dot ( v , h ) , 0.0 , 1.0 ) ; 
    
    AngularInfo angularInfo = { 
        NdotL , 
        NdotV , 
        NdotH , 
        LdotH , 
        VdotH , 
        float3 ( 0 , 0 , 0 ) 
    } ; 
    
    return angularInfo ; 
} 

#line 123 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"


#line 1 "PixelParams.hlsl"


#line 17
float4 getPixelColor ( VS_OUTPUT_SCENE Input ) 
{ 
    float4 color = float4 ( 1.0 , 1.0 , 1.0 , 1.0 ) ; 
    
#line 23
    
    
    return color ; 
} 

#line 30
float3 getPixelNormal ( VS_OUTPUT_SCENE Input ) 
{ 
    float2 UV = getNormalUV ( Input ) ; 
    
#line 51
    
    float3x3 tbn = float3x3 ( Input . Tangent , Input . Binormal , Input . Normal ) ; 
    
    
    
    float3 n = getNormalTexture ( Input ) ; 
    n = normalize ( mul ( transpose ( tbn ) , ( ( 2.0 * n - 1.0 ) ) ) ) ; 
    
#line 61
    
    
    return n ; 
} 



#line 124 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"


#line 1 "shadowFiltering.h"


#line 20

Texture2D shadowMap : register ( T9 ) ; 
SamplerComparisonState samShadow : register ( s9 ) ; 


#line 28



float FilterShadow ( Texture2D shadowMap , float3 uv ) 
{ 
    float shadow = 0.0 ; 
    
    static const int kernelLevel = 2 ; 
    static const int kernelWidth = 2 * kernelLevel + 1 ; 
    [ unroll ] for ( int i = - kernelLevel ; i <= kernelLevel ; i ++ ) 
    { 
        [ unroll ] for ( int j = - kernelLevel ; j <= kernelLevel ; j ++ ) 
        { 
            shadow += shadowMap . SampleCmpLevelZero ( samShadow , uv . xy , uv . z , int2 ( i , j ) ) . r ; 
        } 
    } 
    
    shadow /= ( kernelWidth * kernelWidth ) ; 
    return shadow ; 
} 


float DoSpotShadow ( in float3 vPosition , Light light ) 
{ 
    
    if ( light . shadowMapIndex < 0 ) 
    return 1.0 ; 
    
    if ( light . type != LightType_Spot ) 
    return 1.0 ; 
    
    float4 shadowTexCoord = mul ( light . mLightViewProj , float4 ( vPosition , 1 ) ) ; 
    shadowTexCoord . xyz = shadowTexCoord . xyz / shadowTexCoord . w ; 
    
#line 63
    shadowTexCoord . x = ( 1.0 + shadowTexCoord . x ) * 0.25 ; 
    shadowTexCoord . y = ( 1.0 - shadowTexCoord . y ) * 0.25 ; 
    
    if ( ( shadowTexCoord . y < 0 ) || ( shadowTexCoord . y > .5 ) ) return 0 ; 
    if ( ( shadowTexCoord . x < 0 ) || ( shadowTexCoord . x > .5 ) ) return 0 ; 
    
#line 70
    float offsetsX [ 4 ] = { 0.0 , 1.0 , 0.0 , 1.0 } ; 
    float offsetsY [ 4 ] = { 0.0 , 0.0 , 1.0 , 1.0 } ; 
    shadowTexCoord . x += offsetsX [ light . shadowMapIndex ] * .5 ; 
    shadowTexCoord . y += offsetsY [ light . shadowMapIndex ] * .5 ; 
    
    shadowTexCoord . z -= light . depthBias ; 
    
    return FilterShadow ( shadowMap , shadowTexCoord . xyz ) ; 
    
#line 80
    
} 

float ReadShadows ( in int2 screenPos , Light light ) 
{ 
    
#line 106
    
    return 1.0f ; 
    
} 

float CalcShadows ( in float3 worldPos , in int2 screenPos , Light light ) 
{ 
    
#line 115
    
    
    return DoSpotShadow ( worldPos , light ) ; 
    
} 


#line 126 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"
struct MaterialInfo 
{ 
    float perceptualRoughness ; 
    float3 reflectance0 ; 
    
    float alphaRoughness ; 
    float3 diffuseColor ; 
    
    float3 reflectance90 ; 
    float3 specularColor ; 
} ; 

#line 167


#line 171
float3 diffuse ( MaterialInfo materialInfo ) 
{ 
    return materialInfo . diffuseColor / M_PI ; 
} 

#line 178
float3 specularReflection ( MaterialInfo materialInfo , AngularInfo angularInfo ) 
{ 
    return materialInfo . reflectance0 + ( materialInfo . reflectance90 - materialInfo . reflectance0 ) * pow ( clamp ( 1.0 - angularInfo . VdotH , 0.0 , 1.0 ) , 5.0 ) ; 
} 

#line 188
float visibilityOcclusion ( MaterialInfo materialInfo , AngularInfo angularInfo ) 
{ 
    float NdotL = angularInfo . NdotL ; 
    float NdotV = angularInfo . NdotV ; 
    float alphaRoughnessSq = materialInfo . alphaRoughness * materialInfo . alphaRoughness ; 
    
    float GGXV = NdotL * sqrt ( NdotV * NdotV * ( 1.0 - alphaRoughnessSq ) + alphaRoughnessSq ) ; 
    float GGXL = NdotV * sqrt ( NdotL * NdotL * ( 1.0 - alphaRoughnessSq ) + alphaRoughnessSq ) ; 
    
    float GGX = GGXV + GGXL ; 
    if ( GGX > 0.0 ) 
    { 
        return 0.5 / GGX ; 
    } 
    return 0.0 ; 
} 

#line 208
float microfacetDistribution ( MaterialInfo materialInfo , AngularInfo angularInfo ) 
{ 
    float alphaRoughnessSq = materialInfo . alphaRoughness * materialInfo . alphaRoughness ; 
    float f = ( angularInfo . NdotH * alphaRoughnessSq - angularInfo . NdotH ) * angularInfo . NdotH + 1.0 ; 
    return alphaRoughnessSq / ( M_PI * f * f + 0.000001f ) ; 
} 

float3 getPointShade ( float3 pointToLight , MaterialInfo materialInfo , float3 normal , float3 view ) 
{ 
    AngularInfo angularInfo = getAngularInfo ( pointToLight , normal , view ) ; 
    
    if ( angularInfo . NdotL > 0.0 || angularInfo . NdotV > 0.0 ) 
    { 
        
        float3 F = specularReflection ( materialInfo , angularInfo ) ; 
        float Vis = visibilityOcclusion ( materialInfo , angularInfo ) ; 
        float D = microfacetDistribution ( materialInfo , angularInfo ) ; 
        
#line 227
        float3 diffuseContrib = ( 1.0 - F ) * diffuse ( materialInfo ) ; 
        float3 specContrib = F * Vis * D ; 
        
#line 231
        return angularInfo . NdotL * ( diffuseContrib + specContrib ) ; 
    } 
    
    return float3 ( 0.0 , 0.0 , 0.0 ) ; 
} 

#line 238
float getRangeAttenuation ( float range , float distance ) 
{ 
    if ( range < 0.0 ) 
    { 
        
        return 1.0 ; 
    } 
    return max ( lerp ( 1 , 0 , distance / range ) , 0 ) ; 
    
} 

#line 250
float getSpotAttenuation ( float3 pointToLight , float3 spotDirection , float outerConeCos , float innerConeCos ) 
{ 
    float actualCos = dot ( normalize ( spotDirection ) , normalize ( - pointToLight ) ) ; 
    if ( actualCos > outerConeCos ) 
    { 
        if ( actualCos < innerConeCos ) 
        { 
            return smoothstep ( outerConeCos , innerConeCos , actualCos ) ; 
        } 
        return 1.0 ; 
    } 
    return 0.0 ; 
} 

float3 applyDirectionalLight ( VS_OUTPUT_SCENE Input , Light light , MaterialInfo materialInfo , float3 normal , float3 view ) 
{ 
    float3 pointToLight = light . direction ; 
    float3 shade = getPointShade ( pointToLight , materialInfo , normal , view ) ; 
    return light . intensity * light . color * shade ; 
} 

float3 applyPointLight ( VS_OUTPUT_SCENE Input , Light light , MaterialInfo materialInfo , float3 normal , float3 view ) 
{ 
    float3 pointToLight = light . position - Input . WorldPos ; 
    float distance = length ( pointToLight ) ; 
    float attenuation = getRangeAttenuation ( light . range , distance ) ; 
    float3 shade = getPointShade ( pointToLight , materialInfo , normal , view ) ; 
    return attenuation * light . intensity * light . color * shade ; 
} 

float3 applySpotLight ( VS_OUTPUT_SCENE Input , Light light , MaterialInfo materialInfo , float3 normal , float3 view ) 
{ 
    float3 pointToLight = light . position - Input . WorldPos ; 
    float distance = length ( pointToLight ) ; 
    float rangeAttenuation = getRangeAttenuation ( light . range , distance ) ; 
    float spotAttenuation = getSpotAttenuation ( pointToLight , - light . direction , light . outerConeCos , light . innerConeCos ) ; 
    float3 shade = getPointShade ( pointToLight , materialInfo , normal , view ) ; 
    return rangeAttenuation * spotAttenuation * light . intensity * light . color * shade ; 
} 

#line 293
float4 mainPS ( VS_OUTPUT_SCENE Input ) : SV_Target 
{ 
    
#line 298
    float perceptualRoughness = 0.0 ; 
    float metallic = 0.0 ; 
    float4 baseColor = float4 ( 0.0 , 0.0 , 0.0 , 1.0 ) ; 
    float3 diffuseColor = float3 ( 0.0 , 0.0 , 0.0 ) ; 
    float3 specularColor = float3 ( 0.0 , 0.0 , 0.0 ) ; 
    float3 f0 = float3 ( 0.04 , 0.04 , 0.04 ) ; 
    
#line 334
    
    
    
    
    
    
#line 341
    float4 mrSample = metallicRoughnessTexture . Sample ( samMetallicRoughness , getMetallicRoughnessUV ( Input ) ) ; 
    perceptualRoughness = mrSample . g * myPerObject_u_RoughnessFactor ; 
    metallic = mrSample . b * myPerObject_u_MetallicFactor ; 
    
#line 347
    
    
#line 350
    
    baseColor = getBaseColorTexture ( Input ) * myPerObject_u_BaseColorFactor ; 
    
#line 354
    
    
    baseColor *= getPixelColor ( Input ) ; 
    
    diffuseColor = baseColor . rgb * ( float3 ( 1.0 , 1.0 , 1.0 ) - f0 ) * ( 1.0 - metallic ) ; 
    
    specularColor = lerp ( f0 , baseColor . rgb , metallic ) ; 
    
    
    
    discardPixelIfAlphaCutOff ( Input ) ; 
    
#line 369
    
    
    perceptualRoughness = clamp ( perceptualRoughness , 0.0 , 1.0 ) ; 
    metallic = clamp ( metallic , 0.0 , 1.0 ) ; 
    
#line 376
    float alphaRoughness = perceptualRoughness * perceptualRoughness ; 
    
#line 379
    float reflectance = max ( max ( specularColor . r , specularColor . g ) , specularColor . b ) ; 
    
    float3 specularEnvironmentR0 = specularColor . rgb ; 
    
    float3 specularEnvironmentR90 = float3 ( 1.0 , 1.0 , 1.0 ) * clamp ( reflectance * 50.0 , 0.0 , 1.0 ) ; 
    
    MaterialInfo materialInfo = { 
        perceptualRoughness , 
        specularEnvironmentR0 , 
        alphaRoughness , 
        diffuseColor , 
        specularEnvironmentR90 , 
        specularColor 
    } ; 
    
#line 396
    float3 color = float3 ( 0.0 , 0.0 , 0.0 ) ; 
    float3 normal = getPixelNormal ( Input ) ; 
    float3 view = normalize ( myPerFrame . u_CameraPos . xyz - Input . WorldPos ) ; 
    
#line 405
    
    
    
    for ( int i = 0 ; i < myPerFrame . u_lightCount ; ++ i ) 
    { 
        Light light = myPerFrame . u_lights [ i ] ; 
        float shadowFactor = CalcShadows ( Input . WorldPos . xyz , int2 ( Input . svPosition . xy ) , light ) ; 
        if ( light . type == LightType_Directional ) 
        { 
            color += applyDirectionalLight ( Input , light , materialInfo , normal , view ) * shadowFactor ; 
        } 
        else if ( light . type == LightType_Point ) 
        { 
            color += applyPointLight ( Input , light , materialInfo , normal , view ) * shadowFactor ; 
        } 
        else if ( light . type == LightType_Spot ) 
        { 
            color += applySpotLight ( Input , light , materialInfo , normal , view ) * shadowFactor ; 
        } 
    } 
    
    
#line 430
    
    
    float ao = 1.0 ; 
    
#line 437
    
    
    float3 emissive = float3 ( 0 , 0 , 0 ) ; 
    
#line 443
    
    
    
    
#line 448
    float4 outColor = float4 ( color , baseColor . a ) ; 
    
#line 490
    
    
    return outColor ; 
}  