#line 1 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"


#line 20


#line 1 "common.h"


#line 20







#line 26 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"


#line 1 "GLTFPbrPass-IO.hlsl"


#line 25
struct VS_INPUT_SCENE 
{ 
    float3 Position : POSITION ; 
    
    float3 Normal : NORMAL ; 
    
    
    float4 Tangent : TANGENT ; 
    
    
    float2 UV0 : TEXCOORD0 ; 
    
    
#line 39
    
    
#line 43
    
    
#line 49
    
    
#line 52
    
    
#line 58
    
    
#line 61
    
} ; 

#line 68
struct VS_OUTPUT_SCENE 
{ 
    float4 svPosition : SV_POSITION ; 
    float3 WorldPos : WORLDPOS ; 
    
    float3 Normal : NORMAL ; 
    
    
    float3 Tangent : TANGENT ; 
    float3 Binormal : BINORMAL ; 
    
    
#line 81
    
    
    float2 UV0 : TEXCOORD0 ; 
    
    
#line 87
    
    
#line 92
    
} ; 



#line 32 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"
cbuffer cbPerFrame : register ( b0 ) 
{ 
    matrix myPerFrame_u_mCameraViewProj ; 
    float4 myPerFrame_u_CameraPos ; 
    float myPerFrame_u_iblFactor ; 
    float myPerFrame_u_EmissiveFactor ; 
} ; 

cbuffer cbPerObject : register ( b1 ) 
{ 
    matrix myPerObject_u_mWorld ; 
} 

matrix GetWorldMatrix ( ) 
{ 
    return myPerObject_u_mWorld ; 
} 

matrix GetCameraViewProj ( ) 
{ 
    return myPerFrame_u_mCameraViewProj ; 
} 



#line 1 "GLTFVertexFactory.hlsl"


#line 21


#line 1 "Skinning.hlsl"


#line 38




#line 26 "GLTFVertexFactory.hlsl"
VS_OUTPUT_SCENE gltfVertexFactory ( VS_INPUT_SCENE input ) 
{ 
    VS_OUTPUT_SCENE Output ; 
    
#line 36
    
    matrix skinningMatrix = 
    { 
        { 1 , 0 , 0 , 0 } , 
        { 0 , 1 , 0 , 0 } , 
        { 0 , 0 , 1 , 0 } , 
        { 0 , 0 , 0 , 1 } 
    } ; 
    
    
    matrix transMatrix = mul ( GetWorldMatrix ( ) , skinningMatrix ) ; 
    Output . WorldPos = mul ( transMatrix , float4 ( input . Position , 1 ) ) . xyz ; 
    Output . svPosition = mul ( GetCameraViewProj ( ) , float4 ( Output . WorldPos , 1 ) ) ; 
    
#line 56
    
    
    
    Output . Normal = normalize ( mul ( transMatrix , float4 ( input . Normal , 0 ) ) . xyz ) ; 
    
    
    
    Output . Tangent = normalize ( mul ( transMatrix , float4 ( input . Tangent . xyz , 0 ) ) . xyz ) ; 
    Output . Binormal = cross ( Output . Normal , Output . Tangent ) * input . Tangent . w ; 
    
    
#line 69
    
    
    
    Output . UV0 = input . UV0 ; 
    
    
#line 77
    
    
    return Output ; 
} 


#line 61 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"
VS_OUTPUT_SCENE mainVS ( VS_INPUT_SCENE input ) 
{ 
    VS_OUTPUT_SCENE Output = gltfVertexFactory ( input ) ; 
    
    return Output ; 
} 
 