#line 1 "C:\\Users\\Ben\\Desktop\\packagebuild\\TressFX-4.1\\bin\\<memory>"


#line 23
cbuffer cbPerFrame : register ( b0 ) 
{ 
    float u_exposure : packoffset ( c0 . x ) ; 
    int u_toneMapper : packoffset ( c0 . y ) ; 
    int u_applyGamma : packoffset ( c0 . z ) ; 
} 

#line 33
struct VERTEX 
{ 
    float2 vTexcoord : TEXCOORD ; 
} ; 

#line 41
Texture2D HDR : register ( t0 ) ; 
SamplerState samLinearWrap : register ( s0 ) ; 

#line 48
float ColToneB ( float hdrMax , float contrast , float shoulder , float midIn , float midOut ) 
{ 
    return 
    - ( ( - pow ( midIn , contrast ) + ( midOut * ( pow ( hdrMax , contrast * shoulder ) * pow ( midIn , contrast ) - 
    pow ( hdrMax , contrast ) * pow ( midIn , contrast * shoulder ) * midOut ) ) / 
    ( pow ( hdrMax , contrast * shoulder ) * midOut - pow ( midIn , contrast * shoulder ) * midOut ) ) / 
    ( pow ( midIn , contrast * shoulder ) * midOut ) ) ; 
} 

#line 58
float ColToneC ( float hdrMax , float contrast , float shoulder , float midIn , float midOut ) 
{ 
    return ( pow ( hdrMax , contrast * shoulder ) * pow ( midIn , contrast ) - pow ( hdrMax , contrast ) * pow ( midIn , contrast * shoulder ) * midOut ) / 
    ( pow ( hdrMax , contrast * shoulder ) * midOut - pow ( midIn , contrast * shoulder ) * midOut ) ; 
} 

#line 65
float ColTone ( float x , float4 p ) 
{ 
    float z = pow ( x , p . r ) ; 
    return z / ( pow ( z , p . g ) * p . b + p . a ) ; 
} 

float3 TimothyTonemapper ( float3 color ) 
{ 
    static float hdrMax = 16.0 ; 
    static float contrast = 2.0 ; 
    static float shoulder = 1.0 ; 
    static float midIn = 0.18 ; 
    static float midOut = 0.18 ; 
    
    float b = ColToneB ( hdrMax , contrast , shoulder , midIn , midOut ) ; 
    float c = ColToneC ( hdrMax , contrast , shoulder , midIn , midOut ) ; 
    
    
    float peak = max ( color . r , max ( color . g , color . b ) ) ; 
    peak = max ( 1e-6f , peak ) ; 
    
    float3 ratio = color / peak ; 
    peak = ColTone ( peak , float4 ( contrast , shoulder , b , c ) ) ; 
    
#line 91
    float crosstalk = 4.0 ; 
    float saturation = contrast ; 
    float crossSaturation = contrast * 16.0 ; 
    
    float white = 1.0 ; 
    
#line 98
    ratio = pow ( abs ( ratio ) , saturation / crossSaturation ) ; 
    ratio = lerp ( ratio , white , pow ( peak , crosstalk ) ) ; 
    ratio = pow ( abs ( ratio ) , crossSaturation ) ; 
    
#line 103
    color = peak * ratio ; 
    return color ; 
} 

#line 110
float3 DX11DSK ( float3 color ) 
{ 
    float MIDDLE_GRAY = 0.72f ; 
    float LUM_WHITE = 1.5f ; 
    
#line 116
    color . rgb *= MIDDLE_GRAY ; 
    color . rgb *= ( 1.0f + color / LUM_WHITE ) ; 
    color . rgb /= ( 1.0f + color ) ; 
    
    return color ; 
} 

#line 126
float3 Reinhard ( float3 color ) 
{ 
    return color / ( 1 + color ) ; 
} 

#line 134
float3 Uncharted2TonemapOp ( float3 x ) 
{ 
    float A = 0.15 ; 
    float B = 0.50 ; 
    float C = 0.10 ; 
    float D = 0.20 ; 
    float E = 0.02 ; 
    float F = 0.30 ; 
    
    return ( ( x * ( A * x + C * B ) + D * E ) / ( x * ( A * x + B ) + D * F ) ) - E / F ; 
} 

float3 Uncharted2Tonemap ( float3 color ) 
{ 
    float W = 11.2 ; 
    return Uncharted2TonemapOp ( 2.0 * color ) / Uncharted2TonemapOp ( W ) ; 
} 

#line 155
float3 ACESFilm ( float3 x ) 
{ 
    float a = 2.51f ; 
    float b = 0.03f ; 
    float c = 2.43f ; 
    float d = 0.59f ; 
    float e = 0.14f ; 
    return saturate ( ( x * ( a * x + b ) ) / ( x * ( c * x + d ) + e ) ) ; 
} 

float3 Pattern ( float2 vTexcoord ) 
{ 
    if ( vTexcoord . x < .5 ) 
    return float3 ( .5 , .5 , .5 ) ; 
    
    uint y = vTexcoord . y * 720 ; 
    if ( ( y & 1 ) == 1 ) 
    return float3 ( 1.0 , 1.0 , 1.0 ) ; 
    
#line 175
    return float3 ( 0 , 0 , 0 ) ; 
} 

float3 ApplyGamma ( float3 color ) 
{ 
    return pow ( abs ( color . rgb ) , 1.0f / 2.2f ) ; 
} 

float3 Tonemap ( float3 color , float exposure , int tonemapper ) 
{ 
    color *= exposure ; 
    
    switch ( tonemapper ) 
    { 
        case 0 : return TimothyTonemapper ( color ) ; 
        case 1 : return DX11DSK ( color ) ; 
        case 2 : return Reinhard ( color ) ; 
        case 3 : return Uncharted2Tonemap ( color ) ; 
        case 4 : return ACESFilm ( color ) ; 
        case 5 : return color ; 
        default : return float3 ( 1 , 1 , 1 ) ; 
    } 
} 

#line 203
float4 mainPS ( VERTEX Input ) : SV_Target 
{ 
    if ( u_exposure < 0 ) 
    { 
        return HDR . Sample ( samLinearWrap , Input . vTexcoord ) ; 
    } 
    
    float4 texColor = HDR . Sample ( samLinearWrap , Input . vTexcoord ) ; 
    
    float3 color = Tonemap ( texColor . rgb , u_exposure , u_toneMapper ) ; 
    
#line 216
    if ( u_applyGamma > 0 ) 
    { 
        color = ApplyGamma ( color ) ; 
    } 
    
    return float4 ( color , 1 ) ; 
} 
 