# Radeon™ Raytracing Analyzer

The Radeon Raytracing Analyzer (RRA) is a tool designed to help improve the raytracing performance of AMD GPUs that support raytracing.
The tool thus far focuses on the visualization of the Acceleration Structures, which consist of Bounding Volume Hierarchies.

Game developers are responsible for creating the acceleration structures and so need a method of visualizing these acceleration structures
and how they can affect performance.

RRA allows the developer to visualize the bounding box hierarchies, and related scene geometries, via a standard rasterizer renderer or using
a traversal counter view which will quickly highlight areas of concern. Once identified, the developer can revisit their BVH generation strategy
to reduce performance bottlenecks.

## Getting Started

1. Install the latest AMD Video/display driver. Completely remove previously installed drivers. On Windows, the driver installation factory reset option should be used.
2. Unzip/Untar the download file. The directory includes the following:
   * Radeon Developer Service (RDS)
   * Radeon Developer Service CLI (RDS headless)
   * Radeon Developer Panel (RDP)
   * Radeon Raytracing Analyzer (RRA)
3. To capture a scene from a game, run the Radeon Developer Panel and follow the instructions in the Help. Help can be found in the following locations:
   * Help web pages exist in the "help" sub directory
   * Help web pages can be accessed from the **Help** button in the Developer Panel
   * Help web pages can be accessed from the Welcome screen in the Radeon Raytracing Analyzer, or from the **Help** menu
   * The documentation is hosted publicly at:
     * https://radeon-developer-panel.readthedocs.io/en/latest/
     * https://radeon-raytracing-analyzer.readthedocs.io/en/latest/

## Important notes
1. In order to capture BVH data, please ensure that acceleration structures are rebuilt each frame.
2. In order to capture ray history information, please ensure that all command buffers are rebuilt each frame.
3. RayQuery is currently only supported from compute shaders. Calling RayQuery from the graphics pipeline is not supported.

## Supported APIs
 * DirectX12
 * Vulkan

## Supported ASICs
* AMD Radeon RX 9000 series
* AMD Radeon RX 7000 series
* AMD Radeon RX 6000 series

## Supported Operating Systems
* Windows® 10
* Windows® 11
* Ubuntu® 24.04 LTS (Vulkan only)
  * With the introduction of 25.20-based Linux drivers, the AMDVLK driver is no longer included in the amdgpu-pro driver package. This is a result of the AMDVLK open-source project being discontinued as mentioned [here](https://github.com/GPUOpen-Drivers/AMDVLK/discussions/416). Instead, the RADV open-source Vulkan® driver is installed by default. Consequently, the Radeon Developer Panel does not support capturing data from Vulkan applications when using these newer driver releases. To analyze Linux Vulkan workloads with Radeon GPU Profiler (RGP), Radeon Raytracing Analyzer (RRA), or Radeon Memory Visualizer (RMV), users can opt for a 25.10-based driver. Alternatively, analysis can be performed using the data capture mechanism integrated within the RADV driver, although this method is not supported by the Radeon Developer Panel. For more information on configuring RADV, refer to the environment variable documentation, specifically the [MESA_VK_TRACE_* environment variables](https://docs.mesa3d.org/envvars.html#envvar-MESA_VK_TRACE) which can be utilized for enabling and configuring tracing.

## Build instructions
See [BUILD.md](BUILD.md) for more details.

## Support ##
For support, please visit the RRA repository github page: https://github.com/GPUOpen-Tools/radeon_raytracing_analyzer

## License ##
Radeon Raytracing Analyzer is licensed under the MIT license. See the [LICENSE.txt](LICENSE.txt) file for complete license information.

## Copyright information ##
Please see [NOTICES.txt](NOTICES.txt) for third party license information.

## DISCLAIMER ##
The information contained herein is for informational purposes only, and is subject to change without notice. While every
precaution has been taken in the preparation of this document, it may contain technical inaccuracies, omissions and typographical
errors, and AMD is under no obligation to update or otherwise correct this information. Advanced Micro Devices, Inc. makes no
representations or warranties with respect to the accuracy or completeness of the contents of this document, and assumes no
liability of any kind, including the implied warranties of noninfringement, merchantability or fitness for particular purposes, with
respect to the operation or use of AMD hardware, software or other products described herein. No license, including implied or
arising by estoppel, to any intellectual property rights is granted by this document. Terms and limitations applicable to the purchase
or use of AMD’s products are as set forth in a signed agreement between the parties or in AMD's Standard Terms and Conditions
of Sale.

AMD, the AMD Arrow logo, Radeon, Ryzen, RDNA and combinations thereof are trademarks of Advanced Micro Devices, Inc. Other product names used in
this publication are for identification purposes only and may be trademarks of their respective companies.

Visual Studio, DirectX and Windows are registered trademarks of Microsoft Corporation in the US and other jurisdictions.

Vulkan and the Vulkan logo are registered trademarks of the Khronos Group Inc.

Python is a registered trademark of the PSF. The Python logos (in several variants) are use trademarks of the PSF as well.

CMake is a registered trademark of Kitware, Inc.

Qt and the Qt logo are registered trademarks of the Qt Company Ltd and/or its subsidiaries worldwide.


© 2022-2025 Advanced Micro Devices, Inc. All rights reserved.
